library ntglobalflag;

type
  _OSVERSIONINFOA = record
    dwOSVersionInfoSize: cardinal;
    dwMajorVersion: cardinal;
    dwMinorVersion: cardinal;
    dwBuildNumber: cardinal;
    dwPlatformId: cardinal;
    szCSDVersion: array[0..127] of AnsiChar; { Maintenance string for PSS usage }
  end;


function GetVersionExA(var lpVersionInformation: _OSVERSIONINFOA): boolean; stdcall; external 'kernel32.dll' name 'GetVersionExA';
function MessageBoxA(hWnd: cardinal; lpText, lpCaption: PAnsiChar; uType: cardinal): Integer; stdcall; external 'user32.dll' name 'MessageBoxA';
procedure ExitProcess(hErrorCode: cardinal); stdcall; external 'kernel32.dll' name 'ExitProcess';


function Enigma_Plugin_About : PWideChar;
begin
  Enigma_Plugin_About := 'Enigma anti-debugger plugin - NtGlobalFlag  Vladimir Sukhov 2 August 2008';
end;

function Enigma_Plugin_Description : PWideChar;
begin
  Enigma_Plugin_Description := 'This plugin uses checkup of NtGlobalFlag to find a debugger.'#10#13 +
                               'If debugger is found, plugin shows a message and terminates application.';
end;

const
  MB_ICONERROR = $00000010;
  VER_PLATFORM_WIN32_NT = 2;
  Title : pchar = 'Error';
  Text : pchar = 'Debugger is found on this machine!';

procedure ExitWithMessage; assembler;
asm
  // Clear some addresses in stack
  mov ecx, 5
  @clear_loop:
  dec ecx
  mov dword ptr [ecx * 4 + esp], 0
  cmp ecx, 0
  jnz @clear_loop
  // Parametr for ExitProcess
  push 0
  // Parameters for MessageBoxA
  push MB_ICONERROR
  push Title
  push Text
  push 0
  // Return address of MessageBox that points to ExitProcess
  lea eax, ExitProcess
  push eax
  jmp MessageBoxA
end;

procedure Enigma_Plugin_OnInit;
var
  lpVersionInfo : _OSVERSIONINFOA;
begin
  // Uses only on NT systems
  lpVersionInfo.dwOSVersionInfoSize := sizeof(lpVersionInfo);
  if not GetVersionExA(lpVersionInfo) then Exit;
  if lpVersionInfo.dwPlatformId <> VER_PLATFORM_WIN32_NT then Exit;

  // This plugin checks if the current project is under debugger
  // Current method works only if the processes was run under debugger and
  // does not work if debugger has beed attached to already executed process
  asm
    mov eax, fs:[30h]
    mov al, [eax+68h]
    and al, 70h
    cmp al, 70h
    jne @not_being_debugged
    call ExitWithMessage
    @not_being_debugged:
  end;
end;

exports
  Enigma_Plugin_About,
  Enigma_Plugin_Description,
  Enigma_Plugin_OnInit;

begin
end.

